#############################################################################
# LFS Handicapping Interface by Krayy
#############################################################################
# Ver 1.0.1 11-08-09 Initial release
# Ver 1.0.5 22-08-09 Major changes to functionality
#                    Added Save/Load code to store and retreive values
#                    Multiple column support for up to 32 players
#                    Changed button names to be unique
# Ver 1.0.6 27/12/09 Updated to be compatible with LFSLapper v5.918
#############################################################################

CatchEvent OnLapperStart()
	CifRegisterModule("Config", "Handicaps", "1.01");

	GlobalVar $applyHandicaps;
	$applyHandicaps = FALSE;
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!hc":
			DoCifConfigHandicaps(0,0);
   		BREAK;
	ENDSWITCH
EndCatchEvent

Sub DoCifConfigHandicaps($KeyFlags,$id)
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Config";
	$cifModuleName="Handicaps";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "User Handicaps");

	# Set various vars for GUI size and location
	$hcOrigT = $CifOrigT+1;			# Top edge of main content window
	$hcOrigL = $CifOrigL+1;	# Left edge of main content window
	$hcOrigR = $CifOrigL+51;
	$MyRowHeight = $CifRowHeight - 1;

	# Left hand titles
	openPrivButton ($DialogPrefix . "luser",$hcOrigL,$hcOrigT,26,$MyRowHeight,1,-1,99,"Nickname");
	openPrivButton ($DialogPrefix . "lweight",$hcOrigL+26,$hcOrigT,11,$MyRowHeight,1,-1,35,"Weight");
	openPrivButton ($DialogPrefix . "lintake",$hcOrigL+37,$hcOrigT,11,$MyRowHeight,1,-1,35,"Intake");

	# Right hand titles
	openPrivButton ($DialogPrefix . "ruser",$hcOrigR,$hcOrigT,26,$MyRowHeight,1,-1,99,"Nickname");
	openPrivButton ($DialogPrefix . "rweight",$hcOrigR+26,$hcOrigT,11,$MyRowHeight,1,-1,35,"Weight");
	openPrivButton ($DialogPrefix . "rintake",$hcOrigR+37,$hcOrigT,11,$MyRowHeight,1,-1,35,"Intake");

	$currPly = GetPlayerInfo();

	$mList = GetListOfPlayers("N");
	$mCount = arrayCount( $mList );
	$plyNum=0;
	$origT = $hcOrigT;
	WHILE ($plyNum < $mCount)
		$thisPlayer = GetPlayerInfo($mList[$plyNum]);

		$Pref = $DialogPrefix . $thisPlayer["UCID"] . "_";

		$IsOdd = $plyNum & 1;
		IF ($IsOdd == 0)	# Check if we are on left or right side
		THEN
			$origT = $origT + $MyRowHeight;
			$origCol = $hcOrigL;
		ELSE
			$origCol=$hcOrigR;
		ENDIF

		# Set the header row and display different info for Admins vs Players
		openPrivButton ($Pref . "hUser",$origCol,$origT,26,$MyRowHeight,1,-1,96,"^7". $thisPlayer["NickName"]);
		IF ( UserIsAdmin( $currPly["UserName"] ) == 1 )
		THEN
			openPrivButton ($Pref . "wCurr",$origCol+26,$origT,8,$MyRowHeight,1,-1,32,$thisPlayer["P_Mass"] ."/^3" . $thisPlayer["H_Mass"] );
			openPrivButton ($Pref . "wMore",$origCol+34,$origT,3,3,1,-1,32,"^1+",DoHandicapper_wMore);
			openPrivButton ($Pref . "wLess",$origCol+34,$origT+2,3,3,1,-1,32,"^2-",DoHandicapper_wLess);

			openPrivButton ($Pref . "iCurr",$origCol+37,$origT,8,$MyRowHeight,1,-1,32,$thisPlayer["P_Tres"] ."/^3" . $thisPlayer["H_Tres"] );
			openPrivButton ($Pref . "iMore",$origCol+45,$origT,3,3,1,-1,32,"^1+",DoHandicapper_iMore);
			openPrivButton ($Pref . "iLess",$origCol+45,$origT+2,3,3,1,-1,32,"^2-",DoHandicapper_iLess);

		ELSE
			openPrivButton ($Pref . "wCurr",$origCol+26,$origT,11,$MyRowHeight,1,-1,32,$thisPlayer["P_Mass"] ."/^3" . $thisPlayer["H_Mass"] );
			openPrivButton ($Pref . "iCurr",$origCol+37,$origT,11,$MyRowHeight,1,-1,32,$thisPlayer["P_Tres"] ."/^3" . $thisPlayer["H_Tres"] );
		ENDIF
		$plyNum=$plyNum+1;
	ENDWHILE
	IF ( UserIsAdmin( $currPly["UserName"] ) == 1 )
	THEN
		# Draw the Load/Save/Reset buttons
		CifCmdButton( 1, "^7Load", DoHandicapper_Load );
		CifCmdButton( 2, "^7Save", DoHandicapper_Save );
		CifCmdButton( 3, "^7Reset", DoHandicapper_Reset );
	ENDIF
EndSub


Sub DoHandicapper_wLess ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"_",0 );
	$Ucid = ToNum(split( $id,"_",1 ));
	$thisPlayer = GetPlayerInfo( GetPlayerVarByUcid( $Ucid, "UserName" ) );
	$uMass = $thisPlayer["H_Mass"];
	IF ($KeyFlags > 1)
	THEN
	    $uMass=$uMass-5;
	ELSE
	    $uMass=$uMass-1;
	ENDIF
	IF ( $uMass < 0 )
	THEN
		$uMass = 0;
	ENDIF
	SetPlayerVar($thisPlayer["UserName"],"H_Mass",$uMass);
	$StatusButton = $DialogPrefix . "_" . $Ucid . "_wCurr";
#	DEBUG ("Updating button " . $StatusButton);
	TextPrivButtonAll( $StatusButton, $thisPlayer["P_Mass"] ."/^3" . $uMass);
EndSub

Sub DoHandicapper_wMore ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"_",0 );
	$Ucid = ToNum(split( $id,"_",1 ));
	$thisPlayer = GetPlayerInfo( GetPlayerVarByUcid( $Ucid, "UserName" ) );
	$uMass = $thisPlayer["H_Mass"];
	IF ($KeyFlags > 1)
	THEN
	    $uMass=$uMass+5;
	ELSE
	    $uMass=$uMass+1;
	ENDIF
	IF ( $uMass > 200 )
	THEN
		$uMass = 200;
	ENDIF
	SetPlayerVar($thisPlayer["UserName"],"H_Mass",$uMass);
	$StatusButton = $DialogPrefix . "_" . $Ucid . "_wCurr";
#	DEBUG ("Updating button " . $StatusButton);
	TextPrivButtonAll( $StatusButton, $thisPlayer["P_Mass"] ."/^3" . $uMass);
EndSub

Sub DoHandicapper_iLess ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"_",0 );
	$Ucid = ToNum(split( $id,"_",1 ));
	$thisPlayer = GetPlayerInfo( GetPlayerVarByUcid( $Ucid, "UserName" ) );
	$uTres = $thisPlayer["H_Tres"];
	IF ($KeyFlags > 1)
	THEN
	    $uTres=$uTres-5;
	ELSE
	    $uTres=$uTres-1;
	ENDIF
	IF ( $uTres < 0 )
	THEN
		$uTres = 0;
	ENDIF
	SetPlayerVar($thisPlayer["UserName"],"H_Tres",$uTres);
	$StatusButton = $DialogPrefix . "_" . $Ucid . "_iCurr";
#	DEBUG ("Updating button " . $StatusButton);
	TextPrivButtonAll( $StatusButton, $thisPlayer["P_Tres"] ."/^3" . $uTres);
EndSub

Sub DoHandicapper_iMore ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"_",0 );
	$Ucid = ToNum(split( $id,"_",1 ));
	$thisPlayer = GetPlayerInfo( GetPlayerVarByUcid( $Ucid, "UserName" ) );
	$uTres = $thisPlayer["H_Tres"];
	IF ($KeyFlags > 1)
	THEN
	    $uTres=$uTres+5;
	ELSE
	    $uTres=$uTres+1;
	ENDIF
	IF ( $uTres > 50 )
	THEN
		$uTres = 50;
	ENDIF
	SetPlayerVar($thisPlayer["UserName"],"H_Tres",$uTres);
	$StatusButton = $DialogPrefix . "_" . $Ucid . "_iCurr";
#	DEBUG ("Updating button " . $StatusButton);
	TextPrivButtonAll( $StatusButton, $thisPlayer["P_Tres"] ."/^3" . $uTres);
EndSub

Sub DoHandicapper_Save($KeyFlags, $id)
	$mList = GetListOfPlayers("N");
	$mCount = arrayCount( $mList );
	$plyNum=0;
	WHILE ($plyNum < $mCount)
		$thisPlayer = GetPlayerInfo( $mList[$plyNum] );
		SetUserStoredValue( $thisPlayer["UserName"], "H_Mass", $thisPlayer["H_Mass"] );
		SetUserStoredValue( $thisPlayer["UserName"], "H_Tres", $thisPlayer["H_Tres"] );
#		DEBUG ("Saving HCs for player " . $thisPlayer["UserName"]);
		$plyNum=$plyNum+1;
	ENDWHILE
EndSub

Sub Handicapper_DbLoad()
	$mList = GetListOfPlayers("N");
	$mCount = arrayCount( $mList );
	$plyNum=0;
	WHILE ($plyNum < $mCount)
		$Player = $mList[$plyNum];
		SetPlayerVar($Player,"H_Mass", GetUserStoredValue( $Player, "H_Mass") );
		SetPlayerVar($Player,"H_Tres", GetUserStoredValue( $Player, "H_Tres") );
#		DEBUG ("Loading HCs for player " . $Player);
		$plyNum=$plyNum+1;
	ENDWHILE
EndSub

Sub DoHandicapper_Load($KeyFlags, $id)
	Handicapper_DbLoad();
	DoCifConfigHandicaps(0,0);
EndSub

Sub HandicapReset()
	$applyHandicaps = FALSE;
	$mList = GetListOfPlayers("N");
	$mCount = arrayCount( $mList );
	$plyNum=0;
	WHILE ($plyNum < $mCount)
		$Player = $mList[$plyNum];
		SetPlayerVar($Player,"H_Mass",0);
		SetPlayerVar($Player,"H_Tres",0);
#		DEBUG ("Loading HCs for player " . $Player);
		$plyNum=$plyNum+1;
	ENDWHILE
EndSub

Sub DoHandicapper_Reset($KeyFlags, $id)
	HandicapReset();
	DoCifConfigHandicaps(0,0);
EndSub

Lang "EN" # Race Events messages
	khc_header_admin = "^0Set Player Handicaps (Admin Mode)";
	khc_header = "^0Current Player Handicaps";
EndLang
